/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.client.render.blockentity;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.block.blockentity.WeatherVaneBlockEntity;
import com.github.mim1q.convenientdecor.init.ModBlocks;
import com.github.mim1q.convenientdecor.init.ModEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;

public class WeatherVaneBlockEntityRenderer
implements BlockEntityRenderer<WeatherVaneBlockEntity> {
    public static final ResourceLocation TEXTURE_GOLD = ConvenientDecor.id("textures/block/weather_vane/gold_top.png");
    public static final ResourceLocation TEXTURE_COPPER = ConvenientDecor.id("textures/block/weather_vane/copper_top.png");
    public static final ResourceLocation TEXTURE_IRON = ConvenientDecor.id("textures/block/weather_vane/iron_top.png");
    public static final ResourceLocation TEXTURE_NETHERITE = ConvenientDecor.id("textures/block/weather_vane/netherite_top.png");
    private final WeatherVaneModel model;

    public WeatherVaneBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new WeatherVaneModel(context.m_173582_(ModEntityModelLayers.WEATHER_VANE));
    }

    public void render(WeatherVaneBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.m_85836_();
        VertexConsumer vertices = vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)WeatherVaneBlockEntityRenderer.getTexture(entity.m_58900_().m_60734_())));
        matrices.m_85841_(1.0f, -1.0f, -1.0f);
        matrices.m_252880_(0.5f, -1.125f, -0.5f);
        matrices.m_85836_();
        matrices.m_252781_(new Quaternionf().rotationY(entity.getYaw(tickDelta) * ((float)Math.PI / 180)));
        matrices.m_252880_(0.0f, -0.8125f, 0.0f);
        this.model.m_7695_(matrices, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.m_85849_();
        matrices.m_252880_(0.0f, 0.75f, 0.0f);
        matrices.m_85849_();
    }

    private static ResourceLocation getTexture(Block block) {
        if (block == ModBlocks.GOLD_WEATHER_VANE) {
            return TEXTURE_GOLD;
        }
        if (block == ModBlocks.COPPER_WEATHER_VANE) {
            return TEXTURE_COPPER;
        }
        if (block == ModBlocks.IRON_WEATHER_VANE) {
            return TEXTURE_IRON;
        }
        return TEXTURE_NETHERITE;
    }

    public static class WeatherVaneModel
    extends Model {
        private final ModelPart root;

        public WeatherVaneModel(ModelPart root) {
            super(RenderType::m_110452_);
            this.root = root;
        }

        public static LayerDefinition getTexturedModelData() {
            MeshDefinition modelData = new MeshDefinition();
            PartDefinition modelPartData = modelData.m_171576_();
            modelPartData.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(0, -16).m_171480_().m_171488_(0.0f, -12.0f, -8.0f, 0.0f, 12.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)32, (int)16);
        }

        public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
            this.root.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }
}

